/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class OscillatingCircuitAP
extends AP6 {
    static final String[][] text = new String[][]{{"de", "Elektromagnetischer Schwingkreis", "Zur\u00fcck", "Start", "Pause", "Weiter", "Zeitlupe", "Kapazit\u00e4t:", "Induktivit\u00e4t:", "Widerstand:", "Maximale Spannung:", "Spannung, Stromst\u00e4rke", "Energie", "Schwingungsdauer:", "Elektrische Feldenergie:", "Magnetische Feldenergie:", "Innere Energie:", "Unged\u00e4mpfte Schwingung", "Ged\u00e4mpfte Schwingung", "Aperiodischer Grenzfall", "Kriechfall", "t", "T", "U", "I", ""}, {"en", "Electromagnetic Oscillating Circuit", "Reset", "Start", "Pause", "Resume", "Slow motion", "Capacity:", "Inductivity:", "Resistance:", "Maximal voltage:", "Voltage, Amperage", "Energy", "Oscillation period:", "Electric field energy:", "Magnetic field energy:", "Internal energy:", "Undamped oscillation", "Damped oscillation", "Critical damping", "Overcritical damping", "t", "T", "V", "I", ""}};
    private int[] gaps = new int[]{10, 10, 10, 0, 10, 5, 5, 5, 10, 0, 10, 5, 10};
    final int width = 720;
    final int height = 420;
    final int width0 = 480;
    FontMetrics fmH;
    Font fC;
    CanvasAP cv;
    Panel6 pan;
    ResetButton buReset;
    StartButton buStart;
    JTextField tfC;
    JTextField tfL;
    JTextField tfR;
    JTextField tfU0;
    JRadioButton rbSlow1;
    JRadioButton rbSlow2;
    JRadioButton rbUI;
    JRadioButton rbE;
    Color bgCanvas;
    Color bgPanel;
    Color colorButton1;
    Color colorButton2;
    Color colorPlus;
    Color colorMinus;
    Color colorE;
    Color colorB;
    Color colorAmperage;
    Color colorVoltage;
    final Color BLACK = Color.black;
    String coauthor;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    String text06;
    String text07;
    String text08;
    String text09;
    String text10;
    String text11;
    String text12;
    String text13;
    String text14;
    String text15;
    String text16;
    String text17;
    String text18;
    String text19;
    String symbolTime;
    String symbolPeriod;
    String symbolVoltage;
    String symbolAmperage;
    double t;
    double tD;
    double cap;
    long capMy;
    final double minCapMy = 100.0;
    final double maxCapMy = 1000.0;
    double ind;
    final double minInd = 1.0;
    final double maxInd = 10.0;
    double res;
    final double maxRes = 1000.0;
    double voltage;
    double voltage0;
    double amperage;
    double amperage0;
    double alpha;
    double omega;
    double omega2;
    double T;
    double phi;
    double cos;
    double sin;
    double u0exp;
    double c1;
    double c2;
    double beta1;
    double beta2;
    double d1;
    double d2;
    double d3;
    double d4;
    boolean on;
    int slow;
    final double pixSec = 200.0;
    final double tSwitch = 0.2;
    final double eps = 1.0E-12;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(720, 420);
    }

    @Override
    protected void initAttributes() {
        this.fC = new Font("Monospaced", 1, 16);
        this.capMy = 500L;
        this.cap = (double)this.capMy / 1000000.0;
        this.ind = 5.0;
        this.res = 0.0;
        this.voltage0 = 10.0;
        this.t = 0.0;
        this.on = false;
        this.slow = 10;
        this.calculation1();
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.colorButton1 = this.getColor(Color.cyan, "colorButton1");
        this.colorButton2 = this.getColor(Color.yellow, "colorButton2");
        this.colorPlus = this.getColor(Color.red, "colorPlus");
        this.colorMinus = this.getColor(Color.blue, "colorMinus");
        this.colorE = this.getColor(Color.red, "colorE");
        this.colorB = this.getColor(Color.blue, "colorB");
        this.colorVoltage = this.getColor(Color.blue, "colorVoltage");
        this.colorAmperage = this.getColor(Color.red, "colorAmperage");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.text06 = this.getText(t[7], "text06");
        this.text07 = this.getText(t[8], "text07");
        this.text08 = this.getText(t[9], "text08");
        this.text09 = this.getText(t[10], "text09");
        this.text10 = this.getText(t[11], "text10");
        this.text11 = this.getText(t[12], "text11");
        this.text12 = this.getText(t[13], "text12");
        this.text13 = this.getText(t[14], "text13");
        this.text14 = this.getText(t[15], "text14");
        this.text15 = this.getText(t[16], "text15");
        this.text16 = this.getText(t[17], "text16");
        this.text17 = this.getText(t[18], "text17");
        this.text18 = this.getText(t[19], "text18");
        this.text19 = this.getText(t[20], "text19");
        this.symbolTime = this.getText(t[21], "symbolTime");
        this.symbolPeriod = this.getText(t[22], "symbolPeriod");
        this.symbolVoltage = this.getText(t[23], "symbolVoltage");
        this.symbolAmperage = this.getText(t[24], "symbolAmperage");
        this.coauthor = this.getText(t[25], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 480, 420);
        this.add(this.cv);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 3, this.gaps);
        this.pan.setBounds(480, 0, 240, 420);
        this.buReset = new ResetButton(this.text01);
        this.pan.add(this.buReset, this.colorButton1, this.BLACK);
        this.buStart = new StartButton(this.text02, this.text03, this.text04);
        this.pan.add(this.buStart, this.colorButton2, this.BLACK);
        ButtonGroup bg1 = new ButtonGroup();
        this.rbSlow1 = new JRadioButton(this.text05 + " (10 x)", true);
        bg1.add(this.rbSlow1);
        this.pan.add(this.rbSlow1, this.bgPanel, this.BLACK);
        this.rbSlow2 = new JRadioButton(this.text05 + " (100 x)", false);
        bg1.add(this.rbSlow2);
        this.pan.add(this.rbSlow2, this.bgPanel, this.BLACK);
        this.tfC = this.pan.newInputField(this.text06, this.microfarad, this.bgPanel, this.BLACK, 2);
        this.tfC.setText(this.toString(this.capMy, 0));
        this.tfL = this.pan.newInputField(this.text07, this.henry, this.bgPanel, this.BLACK, 2);
        this.tfL.setText(this.toString(this.ind, 2));
        this.tfR = this.pan.newInputField(this.text08, this.ohm, this.bgPanel, this.BLACK, 2);
        this.tfR.setText(this.toString(this.res, 1));
        this.tfU0 = this.pan.newInputField(this.text09, this.volt, this.bgPanel, this.BLACK, 2);
        this.tfU0.setText(this.toString(this.voltage0, 1));
        ButtonGroup bg2 = new ButtonGroup();
        this.rbUI = new JRadioButton(this.text10, true);
        bg2.add(this.rbUI);
        this.pan.add(this.rbUI, this.bgPanel, this.BLACK);
        this.rbE = new JRadioButton(this.text11, false);
        bg2.add(this.rbE);
        this.pan.add(this.rbE, this.bgPanel, this.BLACK);
        this.pan.add(1999);
        this.pan.add(this.coauthor);
        this.add(this.pan);
        this.buReset.addActionListener(this);
        this.buStart.addActionListener(this);
        this.rbSlow1.addActionListener(this);
        this.rbSlow2.addActionListener(this);
        this.rbUI.addActionListener(this);
        this.rbE.addActionListener(this);
    }

    @Override
    public void run() {
        long t0 = System.currentTimeMillis();
        while (this.thr == Thread.currentThread()) {
            if (this.on) {
                this.cv.repaint();
            }
            try {
                Thread.sleep(this.on ? 50L : 100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long t1 = System.currentTimeMillis();
            double dt = (double)(t1 - t0) / (1000.0 * (double)this.slow);
            if (this.t < 0.2 && this.slow == 100) {
                dt *= 10.0;
            }
            if (this.on) {
                this.t += dt;
            }
            t0 = t1;
        }
    }

    void calculation1() {
        this.alpha = this.res / (2.0 * this.ind);
        long res10 = Math.round(this.res * 10.0);
        double a = 4.0E8 * this.ind - (double)(res10 * res10 * this.capMy);
        double b = 400.0 * this.ind * this.ind * (double)this.capMy;
        this.omega2 = a / b;
        this.omega = Math.sqrt(Math.abs(this.omega2));
        if (this.omega2 > 0.0) {
            this.c1 = this.alpha / this.omega;
            this.c2 = this.alpha * this.alpha / this.omega + this.omega;
        } else if (this.omega2 < 0.0) {
            this.beta1 = this.alpha - this.omega;
            this.beta2 = this.alpha + this.omega;
            this.d1 = this.beta2 * this.voltage0 / (this.beta2 - this.beta1);
            this.d2 = this.beta1 * this.voltage0 / (this.beta1 - this.beta2);
            this.d3 = this.cap * this.beta1 * this.d1;
            this.d4 = this.cap * this.beta2 * this.d2;
        }
        this.T = this.omega2 != 0.0 ? Math.PI * 2 / this.omega : 4.0 / this.alpha;
        this.calculation2(this.T / 4.0);
        this.amperage0 = this.amperage(this.T / 4.0);
        double c = this.T / 8.0;
        for (int i = 0; i < 10; ++i) {
            this.calculation2(c);
            this.amperage0 = Math.max(this.amperage0, this.amperage(c));
            c /= 2.0;
        }
        this.repaint();
    }

    void calculation2(double t) {
        if (this.omega2 > 0.0) {
            this.u0exp = this.voltage0 * Math.exp(-this.alpha * t);
            this.sin = Math.sin(this.omega * t);
            this.cos = Math.cos(this.omega * t);
        }
    }

    double voltage(double t) {
        if (this.omega2 > 0.0) {
            return this.u0exp * (this.cos + this.c1 * this.sin);
        }
        if (this.omega2 < 0.0) {
            return this.d1 * Math.exp(-this.beta1 * t) + this.d2 * Math.exp(-this.beta2 * t);
        }
        return this.voltage0 * (1.0 + this.alpha * t) * Math.exp(-this.alpha * t);
    }

    double amperage(double t) {
        if (this.omega2 > 0.0) {
            return this.cap * this.u0exp * this.c2 * this.sin;
        }
        if (this.omega2 < 0.0) {
            return this.d3 * Math.exp(-this.beta1 * t) + this.d4 * Math.exp(-this.beta2 * t);
        }
        return this.cap * this.alpha * this.alpha * this.voltage0 * t * Math.exp(-this.alpha * t);
    }

    void changeValues() {
        this.capMy = (long)this.inputTF(this.tfC, 100.0, 1000.0, 0);
        this.cap = (double)this.capMy / 1000000.0;
        this.ind = this.inputTF(this.tfL, 1.0, 10.0, 2);
        this.res = this.inputTF(this.tfR, 0.0, 1000.0, 1);
        this.voltage0 = this.inputTF(this.tfU0, 5.0, 20.0, 1);
        this.calculation1();
    }

    void enableTF(boolean flag) {
        this.tfC.setEnabled(flag);
        this.tfL.setEnabled(flag);
        this.tfR.setEnabled(flag);
        this.tfU0.setEnabled(flag);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o == this.buReset) {
            this.buStart.setState(0);
            this.enableTF(true);
            this.t = 0.0;
        } else if (o == this.buStart) {
            this.buStart.setState();
            this.enableTF(false);
            this.changeValues();
        } else if (o instanceof JTextField) {
            this.changeValues();
        }
        boolean bl = this.on = this.buStart.getState() == 1;
        if (this.rbSlow1.isSelected()) {
            this.slow = 10;
        } else if (this.rbSlow2.isSelected()) {
            this.slow = 100;
        }
        this.repaint();
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, OscillatingCircuitAP.this.bgCanvas);
            OscillatingCircuitAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void switch0(Graphics2D g, int u, int v) {
            CanvasAP.circle(g, 2.0, u, v, 3.0, OscillatingCircuitAP.this.BLACK, false);
            CanvasAP.circle(g, 2.0, u - 20, v - 40, 3.0, OscillatingCircuitAP.this.BLACK, false);
            CanvasAP.circle(g, 2.0, u + 20, v - 40, 3.0, OscillatingCircuitAP.this.BLACK, false);
            double w = 0.35;
            if (OscillatingCircuitAP.this.t < 0.2) {
                w = (OscillatingCircuitAP.this.t - 0.1) * 0.7 / 0.2;
            }
            double cos = Math.cos(w);
            double sin = Math.sin(w);
            CanvasAP.line(g, 3.0, (double)u + 4.0 * sin, (double)v - 4.0 * cos, (double)u + 50.0 * sin, (double)v - 50.0 * cos);
        }

        void condensator(Graphics2D g, int x, int y) {
            int h = OscillatingCircuitAP.this.voltage > 0.0 ? -25 : 25;
            double q = Math.abs(OscillatingCircuitAP.this.voltage / OscillatingCircuitAP.this.voltage0);
            if (q > 0.05) {
                g.setColor(OscillatingCircuitAP.this.colorE);
                for (int i = 0; i <= 10; ++i) {
                    double d = (double)(i * 6) / Math.sqrt(q);
                    this.fieldLineE(g, x, y, d);
                }
            }
            CanvasAP.rectangle(g, x - 30, y - 15, 61.0, 5.0, OscillatingCircuitAP.this.BLACK);
            CanvasAP.rectangle(g, x - 30, y + 10, 61.0, 5.0, OscillatingCircuitAP.this.BLACK);
            CanvasAP.rectangle(g, x - 25, y + h - 1, 11.0, 3.0, OscillatingCircuitAP.this.colorPlus);
            CanvasAP.rectangle(g, x - 21, y + h - 5, 3.0, 11.0, OscillatingCircuitAP.this.colorPlus);
            CanvasAP.rectangle(g, x - 25, y - h - 1, 11.0, 3.0, OscillatingCircuitAP.this.colorMinus);
        }

        void fieldLineE(Graphics2D g, int x, int y, double d) {
            int h2;
            if (OscillatingCircuitAP.this.voltage == 0.0) {
                return;
            }
            int n = h2 = OscillatingCircuitAP.this.voltage > 0.0 ? 4 : -4;
            if (d <= 30.0) {
                double x0 = (double)x + d;
                double x1 = (double)x - d;
                CanvasAP.line(g, x0, y - 10, x0, y + 10);
                CanvasAP.line(g, x1, y - 10, x1, y + 10);
                CanvasAP.line(g, x0, y + h2, x0 - 2.0, y - h2);
                CanvasAP.line(g, x0, y + h2, x0 + 2.0, y - h2);
                CanvasAP.line(g, x1, y + h2, x1 - 2.0, y - h2);
                CanvasAP.line(g, x1, y + h2, x1 + 2.0, y - h2);
            } else if (d < 35.0) {
                double h = d - 30.0;
                int a = (int)Math.round(h * h);
                int b = (int)(10.5 + d / 10.0);
                if (a > 0) {
                    g.drawArc(x + 30 - a, y - b, 2 * a, 2 * b, 270, 180);
                    g.drawArc(x - 30 - a, y - b, 2 * a, 2 * b, 90, 180);
                } else {
                    CanvasAP.line(g, x + 30, y - b, x + 30, y + b);
                    CanvasAP.line(g, x - 30, y - b, x - 30, y + b);
                }
                CanvasAP.line(g, x + 30 + a, y + h2, x + 28 + a, y - h2);
                CanvasAP.line(g, x + 30 + a, y + h2, x + 32 + a, y - h2);
                CanvasAP.line(g, x - 30 - a, y + h2, x - 32 - a, y - h2);
                CanvasAP.line(g, x - 30 - a, y + h2, x - 28 - a, y - h2);
            }
        }

        void fieldLineB(Graphics2D g, int x, int y, double d) {
            int h2;
            if (OscillatingCircuitAP.this.amperage == 0.0) {
                return;
            }
            int n = h2 = OscillatingCircuitAP.this.amperage > 0.0 ? 4 : -4;
            if (d == 0.0) {
                CanvasAP.line(g, x, y - 120, x, y + 120);
                CanvasAP.line(g, x, y - 110 - h2, x - 2, y - 110 + h2);
                CanvasAP.line(g, x, y - 110 - h2, x + 2, y - 110 + h2);
                CanvasAP.line(g, x, y - 5 - h2, x - 2, y - 5 + h2);
                CanvasAP.line(g, x, y - 5 - h2, x + 2, y - 5 + h2);
                CanvasAP.line(g, x, y + 110 - h2, x - 2, y + 110 + h2);
                CanvasAP.line(g, x, y + 110 - h2, x + 2, y + 110 + h2);
            } else if (d <= 15.0) {
                int x0 = (int)Math.round((double)x + d);
                int x1 = (int)Math.round((double)x - d);
                int y1 = y - 60;
                int y2 = y + 60;
                CanvasAP.line(g, x0, y1, x0, y2);
                CanvasAP.line(g, x1, y1, x1, y2);
                y1 = y - 5 - h2;
                y2 = y - 5 + h2;
                CanvasAP.line(g, x0, y1, x0 - 2, y2);
                CanvasAP.line(g, x0, y1, x0 + 2, y2);
                CanvasAP.line(g, x1, y1, x1 - 2, y2);
                CanvasAP.line(g, x1, y1, x1 + 2, y2);
                int r = (int)Math.round(100.0 / d);
                int r2 = 2 * r;
                y1 = y - 60;
                y2 = y + 60;
                g.drawArc(x0, y1 - r, r2, r2, 90, 90);
                g.drawArc(x0, y2 - r, r2, r2, 180, 90);
                g.drawArc(x1 - r2, y1 - r, r2, r2, 0, 90);
                g.drawArc(x1 - r2, y2 - r, r2, r2, 270, 90);
                int a = (int)Math.round(2000.0 / (d * d));
                if (a > 50) {
                    return;
                }
                int b = 60 + r;
                g.drawArc(x0 + r - a, y - b, 2 * a, 2 * b, 270, 180);
                g.drawArc(x1 - r - a, y - b, 2 * a, 2 * b, 90, 180);
            }
        }

        void coilBG(Graphics2D g, int x, int y) {
            g.setColor(Color.gray);
            double x1 = x;
            double y1 = y - 60;
            double h = 0.2617993877991494;
            for (int i = 1; i <= 120; ++i) {
                double x0 = x1;
                double y0 = y1;
                x1 = (double)x + 20.0 * Math.sin((double)i * h);
                y1 = y - 60 + i;
                if (!(x1 < x0)) continue;
                CanvasAP.line(g, 3.0, x0, y0, x1, y1);
            }
            double q = Math.abs(OscillatingCircuitAP.this.amperage / OscillatingCircuitAP.this.amperage0);
            if (q > 0.05) {
                g.setColor(OscillatingCircuitAP.this.colorB);
                h = 4.0 / Math.sqrt(q);
                for (int i = 0; i <= 10; ++i) {
                    this.fieldLineB(g, x, y, (double)i * h);
                }
            }
        }

        void coilFG(Graphics2D g, int x, int y) {
            g.setColor(OscillatingCircuitAP.this.BLACK);
            double x1 = x;
            double y1 = y - 60;
            double h = 0.2617993877991494;
            for (int i = 1; i <= 120; ++i) {
                double x0 = x1;
                double y0 = y1;
                x1 = (double)x + 20.0 * Math.sin((double)i * h);
                y1 = y - 60 + i;
                if (!(x1 > x0)) continue;
                CanvasAP.line(g, 3.0, x0, y0, x1, y1);
            }
        }

        void clock(Graphics2D g, int x, int y) {
            CanvasAP.rectangle(g, x - 60, y - 15, 120.0, 30.0, Color.gray, true);
            CanvasAP.rectangle(g, x - 50, y - 10, 100.0, 20.0, OscillatingCircuitAP.this.BLACK);
            g.setColor(Color.red);
            g.setFont(OscillatingCircuitAP.this.fC);
            double tt = Math.max(OscillatingCircuitAP.this.t - 0.2, 0.0);
            int n = (int)(tt / 100.0);
            String s = ((tt -= (double)(100 * n)) < 10.0 ? "0" : "") + this.frame.toString(tt, 3) + " " + OscillatingCircuitAP.this.second;
            this.alignText(g, s, OscillatingCircuitAP.this.fC, 1, x, y + 5);
            g.setFont(this.fH);
        }

        void axes(Graphics2D g, int x, int y) {
            g.setColor(OscillatingCircuitAP.this.BLACK);
            CanvasAP.arrow(g, x - 20, y, x + 250, y);
            CanvasAP.arrow(g, x, y + 80, x, y - 80);
            this.alignText(g, OscillatingCircuitAP.this.symbolTime, this.fH, 1, x + 245, y + 15);
            g.setColor(OscillatingCircuitAP.this.colorVoltage);
            this.alignText(g, OscillatingCircuitAP.this.symbolVoltage, this.fH, 2, x - 8, y - 70);
            g.setColor(OscillatingCircuitAP.this.colorAmperage);
            this.alignText(g, OscillatingCircuitAP.this.symbolAmperage, this.fH, 0, x + 8, y - 70);
        }

        void values(Graphics2D g, int x, int y) {
            OscillatingCircuitAP.this.tD = OscillatingCircuitAP.this.t < 0.2 ? OscillatingCircuitAP.this.t : (OscillatingCircuitAP.this.t < 0.8 ? 0.2 : OscillatingCircuitAP.this.t - 0.6);
            double x0 = (double)x + 200.0 * (OscillatingCircuitAP.this.t - OscillatingCircuitAP.this.tD);
            double y0 = (double)y - 3.0 * OscillatingCircuitAP.this.voltage;
            CanvasAP.circle(g, x0, y0, 2.5, OscillatingCircuitAP.this.colorVoltage);
            y0 = (double)y - 40.0 * OscillatingCircuitAP.this.amperage / OscillatingCircuitAP.this.amperage0;
            CanvasAP.circle(g, x0, y0, 2.5, OscillatingCircuitAP.this.colorAmperage);
            CanvasAP.setAntiAliasing(g, false);
            g.setColor(OscillatingCircuitAP.this.colorVoltage);
            String s = OscillatingCircuitAP.this.symbolVoltage + " = ";
            s = s + this.frame.toString(OscillatingCircuitAP.this.voltage, 2) + " " + OscillatingCircuitAP.this.volt;
            g.drawString(s, x + 40, y - 50);
            g.setColor(OscillatingCircuitAP.this.colorAmperage);
            s = OscillatingCircuitAP.this.symbolAmperage + " = ";
            s = s + this.frame.toString(OscillatingCircuitAP.this.amperage, 3) + " " + OscillatingCircuitAP.this.ampere;
            g.drawString(s, x + 150, y - 50);
            CanvasAP.setAntiAliasing(g, true);
        }

        void diagramU(Graphics2D g, int x, int y) {
            double t0 = Math.max(OscillatingCircuitAP.this.tD - 0.2, 0.0);
            g.setColor(OscillatingCircuitAP.this.colorVoltage);
            OscillatingCircuitAP.this.calculation2(t0);
            double u = OscillatingCircuitAP.this.voltage(t0);
            double x1 = x;
            double y1 = (double)y - 3.0 * u;
            while (x1 < (double)(x + 240)) {
                double x0 = x1;
                double y0 = y1;
                x1 = x0 + 1.0;
                double tt = t0 + (x1 - (double)x) / 200.0;
                OscillatingCircuitAP.this.calculation2(tt);
                u = OscillatingCircuitAP.this.voltage(tt);
                y1 = (double)y - 3.0 * u;
                CanvasAP.line(g, x0, y0, x1, y1);
            }
        }

        void diagramI(Graphics2D g, int x, int y) {
            double t0 = Math.max(OscillatingCircuitAP.this.tD - 0.2, 0.0);
            g.setColor(OscillatingCircuitAP.this.colorAmperage);
            OscillatingCircuitAP.this.calculation2(t0);
            double i = OscillatingCircuitAP.this.amperage(t0);
            double x1 = x;
            double y1 = (double)y - 40.0 * i / OscillatingCircuitAP.this.amperage0;
            while (x1 < (double)(x + 240)) {
                double x0 = x1;
                double y0 = y1;
                x1 = x0 + 1.0;
                double tt = t0 + (x1 - (double)x) / 200.0;
                OscillatingCircuitAP.this.calculation2(tt);
                i = OscillatingCircuitAP.this.amperage(tt);
                y1 = (double)y - 40.0 * i / OscillatingCircuitAP.this.amperage0;
                CanvasAP.line(g, x0, y0, x1, y1);
            }
        }

        void diagramUI(Graphics2D g, int x, int y) {
            this.axes(g, x, y);
            this.values(g, x, y);
            this.diagramU(g, x, y);
            this.diagramI(g, x, y);
        }

        void diagramE(Graphics2D g, int x, int y) {
            double e = OscillatingCircuitAP.this.cap / 2.0 * OscillatingCircuitAP.this.voltage0 * OscillatingCircuitAP.this.voltage0;
            double eE = OscillatingCircuitAP.this.cap / 2.0 * OscillatingCircuitAP.this.voltage * OscillatingCircuitAP.this.voltage;
            double hE = 150.0 * eE / e;
            double eM = OscillatingCircuitAP.this.ind / 2.0 * OscillatingCircuitAP.this.amperage * OscillatingCircuitAP.this.amperage;
            double eEM = eE + eM;
            double hEM = 150.0 * eEM / e;
            CanvasAP.rectangle(g, x, y, 50.0, hE, OscillatingCircuitAP.this.colorE, true);
            CanvasAP.rectangle(g, x, (double)y + hE, 50.0, hEM - hE, OscillatingCircuitAP.this.colorB, true);
            CanvasAP.rectangle(g, x, (double)y + hEM, 50.0, 150.0 - hEM, OscillatingCircuitAP.this.BLACK);
            CanvasAP.setAntiAliasing(g, false);
            g.setColor(OscillatingCircuitAP.this.colorE);
            g.drawString(OscillatingCircuitAP.this.text13, x + 70, y + 20);
            String s = OscillatingCircuitAP.this.toString2(eE, 3, 1.0E-12) + " " + OscillatingCircuitAP.this.joule;
            g.drawString(s, x + 70, y + 35);
            g.setColor(OscillatingCircuitAP.this.colorB);
            g.drawString(OscillatingCircuitAP.this.text14, x + 70, y + 70);
            s = OscillatingCircuitAP.this.toString2(eM, 3, 1.0E-12) + " " + OscillatingCircuitAP.this.joule;
            g.drawString(s, x + 70, y + 85);
            g.setColor(OscillatingCircuitAP.this.BLACK);
            g.drawString(OscillatingCircuitAP.this.text15, x + 70, y + 120);
            double eI = e - eEM;
            if (eI < 0.0) {
                eI = 0.0;
            }
            s = OscillatingCircuitAP.this.toString2(eI, 3, 1.0E-12) + " " + OscillatingCircuitAP.this.joule;
            g.drawString(s, x + 70, y + 135);
            CanvasAP.setAntiAliasing(g, true);
        }

        void wires(Graphics2D g) {
            CanvasAP.line(g, 2.0, 60.0, 120.0, 60.0, 40.0);
            CanvasAP.line(g, 2.0, 60.0, 40.0, 176.0, 40.0);
            CanvasAP.line(g, 2.0, 200.0, 84.0, 200.0, 115.0);
            CanvasAP.line(g, 2.0, 200.0, 145.0, 200.0, 220.0);
            CanvasAP.line(g, 2.0, 60.0, 220.0, 340.0, 220.0);
            CanvasAP.line(g, 2.0, 60.0, 220.0, 60.0, 138.0);
            CanvasAP.line(g, 2.0, 224.0, 40.0, 340.0, 40.0);
            CanvasAP.line(g, 2.0, 340.0, 40.0, 340.0, 70.0);
            CanvasAP.line(g, 2.0, 340.0, 190.0, 340.0, 220.0);
        }

        void arrowsCurrent(Graphics2D g) {
            int y0;
            if (Math.abs(OscillatingCircuitAP.this.amperage / OscillatingCircuitAP.this.amperage0) <= 0.05) {
                return;
            }
            g.setColor(OscillatingCircuitAP.this.colorAmperage);
            int n = y0 = OscillatingCircuitAP.this.res == 0.0 ? 30 : 20;
            if (OscillatingCircuitAP.this.amperage > 0.0) {
                CanvasAP.arrow(g, 3.0, 290.0, 230.0, 260.0, 230.0);
                CanvasAP.arrow(g, 3.0, 260.0, y0, 290.0, y0);
            } else {
                CanvasAP.arrow(g, 3.0, 260.0, 230.0, 290.0, 230.0);
                CanvasAP.arrow(g, 3.0, 290.0, y0, 260.0, y0);
            }
        }

        void writePeriod(Graphics2D g) {
            g.setColor(OscillatingCircuitAP.this.BLACK);
            this.alignText(g, OscillatingCircuitAP.this.text12, this.fH, 1, 90, 350);
            String s = OscillatingCircuitAP.this.symbolPeriod + " = " + this.frame.toString(OscillatingCircuitAP.this.T, 3) + " " + OscillatingCircuitAP.this.second;
            this.alignText(g, s, this.fH, 1, 90, 370);
        }

        void writeType(Graphics2D g) {
            g.setColor(OscillatingCircuitAP.this.BLACK);
            String s = OscillatingCircuitAP.this.res == 0.0 ? OscillatingCircuitAP.this.text16 : (OscillatingCircuitAP.this.omega2 > 0.0 ? OscillatingCircuitAP.this.text17 : (OscillatingCircuitAP.this.omega2 == 0.0 ? OscillatingCircuitAP.this.text18 : OscillatingCircuitAP.this.text19));
            this.alignText(g, s, this.fH, 1, 320, 390);
        }

        @Override
        public void paint(Graphics g) {
            boolean ui;
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            if (OscillatingCircuitAP.this.t > 0.2) {
                OscillatingCircuitAP.this.calculation2(OscillatingCircuitAP.this.t - 0.2);
            }
            OscillatingCircuitAP.this.voltage = OscillatingCircuitAP.this.t < 0.2 ? OscillatingCircuitAP.this.voltage0 : OscillatingCircuitAP.this.voltage(OscillatingCircuitAP.this.t - 0.2);
            OscillatingCircuitAP.this.amperage = OscillatingCircuitAP.this.t < 0.2 ? 0.0 : OscillatingCircuitAP.this.amperage(OscillatingCircuitAP.this.t - 0.2);
            g.setFont(this.fH);
            this.condensator(g2, 200, 130);
            this.coilBG(g2, 340, 130);
            this.coilFG(g2, 340, 130);
            CanvasAP.rectangle(g2, 40.0, 120.0, 41.0, 2.0, OscillatingCircuitAP.this.BLACK);
            CanvasAP.rectangle(g2, 50.0, 132.0, 21.0, 6.0, OscillatingCircuitAP.this.BLACK);
            this.switch0(g2, 200, 80);
            this.wires(g2);
            if (OscillatingCircuitAP.this.res > 0.0) {
                CanvasAP.rectangle(g2, 2.0, 250.0, 33.0, 50.0, 15.0, OscillatingCircuitAP.this.bgCanvas, true);
            }
            CanvasAP.circle(g2, 200.0, 220.0, 3.5, OscillatingCircuitAP.this.BLACK);
            CanvasAP.rectangle(g2, 25.0, 119.0, 11.0, 3.0, OscillatingCircuitAP.this.colorPlus);
            CanvasAP.rectangle(g2, 29.0, 115.0, 3.0, 11.0, OscillatingCircuitAP.this.colorPlus);
            CanvasAP.rectangle(g2, 25.0, 134.0, 11.0, 3.0, OscillatingCircuitAP.this.colorMinus);
            this.arrowsCurrent(g2);
            this.clock(g2, 90, 280);
            if (OscillatingCircuitAP.this.omega2 > 0.0) {
                this.writePeriod(g2);
            }
            if (ui = OscillatingCircuitAP.this.rbUI.isSelected()) {
                this.diagramUI(g2, 180, 320);
            } else {
                this.diagramE(g2, 200, 250);
            }
            if (ui) {
                this.writeType(g2);
            }
        }
    }
}

